﻿using System;
using System.Reflection;

namespace SerienHelper
{
	public class OutputData
	{
		public DateTime Date { get; set; }
		public int FoldersNotFoundCount { get; set; }
		public List<string> FoldersNotFoundPaths { get; set; } = new();
		public int ShowInfoNotFoundCount { get; set; }
		public List<string> ShowInfoNotFoundPaths { get; set; } = new();
		public List<OutputStructureIssue> StructureIssues { get; set; } = new();
		public List<OutputEpisodesBlock> EpisodesBlocks { get; set; } = new();
		public string Version { get; set; } = "";
		public string CompareFolder { get; set; } = "";

		public OutputData()
		{
			Date = DateTime.Now;

			var version = Assembly.GetExecutingAssembly().GetName().Version;
			Version = version?.Major + "." + version?.Minor;
		}
	}

	public class OutputStructureIssue
	{
		public string Path { get; set; } = "";
		public List<string> StructureIssues { get; set; } = new();
		public List<string> SeasonStructureIssues { get; set; } = new();
	}


	public class OutputEpisodesBlock
	{
		public string Path { get; set; } = "";
		public int Count { get; set; }
		public string Title { get; set; } = "";

		public List<OutputSeason> Seasons { get; set; } = new();
	}

	public class OutputSeason 
	{
		public int Nr { get; set; } = -1;
		public string Title { get; set; } = "";
		public string Path { get; set; } = "";
		public List<OutputEpisode> Episodes { get; set;} = new();
	}

	public class OutputEpisode 
	{ 
		public int Nr { get; set; }
		public string Title { get; set; } = "";
		public string Url { get; set; } = "";
	}
}