﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using System.Text.Json.Serialization;
using System.Threading.Tasks;
using static SerienHelper.API.Episode;

namespace SerienHelper.API
{
	public class ShowInfo
	{
		public string Title { get; set; } = String.Empty;
		public string Description { get; set; } = String.Empty;
		public string Url { get; set; } = String.Empty;
		public string ImageUrl { get; set; } = String.Empty;
		public string ProductionStart { get; set; } = String.Empty;
		public string ProductionEnd { get; set; } = String.Empty;
		public string Author { get; set; } = String.Empty;
		public List<string> Authors { get; set; } = new List<string>();
		public List<string> Regie { get; set; } = new List<string>();
		public string MainArtist { get; set; } = String.Empty;
		public List<string> Artists { get; set; } = new List<string>();
		public List<string> Producer { get; set; } = new List<string>();
		public List<string> Genre { get; set; } = new List<string>();

		public List<Season> Seasons { get; set; } = new List<Season>();

		public static ShowInfo Load(string path)
		{
			var json = File.ReadAllText(path, Encoding.UTF8);
			return JsonSerializer.Deserialize<ShowInfo>(json)!;
		}
	}

	public class Season
	{
		public int Nr { get; set; }
		public string Title { get; set; } = string.Empty;
		public string Description { get; set; } = string.Empty;

		public string Url { get; set; }
		public string ImageUrl { get; set; }
		public string ProductionStart { get; set; } = string.Empty;
		public string ProductionEnd { get; set; } = string.Empty;

		public ESeasonType SeasonType { get; set; }

		public List<Episode> Episodes { get; set; } = new List<Episode>();

		public List<ELanguage> Languages
		{
			get
			{
				return Episodes.SelectMany(x => x.Languages).Distinct().ToList();
			}
		}

		public enum ESeasonType
		{
			None = 0,
			Season,
			Special
		}
	}

	public class Episode
	{
		public int Nr { get; set; }
		public string Title { get; set; } = string.Empty;
		public string AlternateTitle { get; set; } = string.Empty;
		public string Description { get; set; } = string.Empty;
		public string Url { get; set; } = string.Empty;
		public string ImageUrl { get; set; } = string.Empty;

		public List<ELanguage> Languages { get; set; } = new List<ELanguage>();

		[JsonIgnore]
		public Season? Season { get; set; }
	}
}
