﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using System.Threading.Tasks;

namespace SerienHelper.API
{
	public class IgnoreList : List<IgnoreListEntry>
	{
		public static IgnoreList Load(string path)
		{
			string json = File.ReadAllText(path);
			return JsonSerializer.Deserialize<IgnoreList>(json)!;
		}

		public void Save(string path)
		{
			File.WriteAllText(path, JsonSerializer.Serialize(this));
		}
	}

	public class IgnoreListEntry
	{
		public IgnoreListEntry(string path) 
		{ 
			Path= path;
		}

		/// <summary>
		/// Path to series folder or episode
		/// </summary>
		public string Path { get; set; }

		public int? EpisodeNr { get; set; } = null;

		/// <summary>
		/// Identifier is episode or folder
		/// </summary>
		public bool IsEpisode => EpisodeNr != null;
	}
}
